//	CCopyFile.h

#ifndef _H_CCopyFile
#define	_H_CCopyFile

typedef enum {
	ADFS_IO_NONE, 
	
	ADFS_IO_READ, 
	ADFS_IO_WRITE, 
	
	ADFS_IO_NUMTYPES
} ADFS_IOType;

#include "CCopyTree.h"

class	CCopyFile {
	
	public: OSErr	ICopyFile(
		CCopyFile		*parent0, 
		CCT_CopyType	copyType, 
		Ptr				myData);
	
	virtual	void	Dispose(void);

	virtual	void	LogCopyFileType(void);

	virtual	OSErr	GetFileInfo(CCT_MemFileRec *fileRecP);

	virtual	OSErr	IsFolder(Boolean *isFolderB);
	virtual	OSErr	CountFilesInFolder(ulong *numFilesL);
	virtual	OSErr	GetIndFileInFolder(ulong fileIndex, Ptr *fileDataP);

	virtual	OSErr	CreateFile(Ptr parentFolderP, CCT_MemFileRec *fileRecP);
	virtual	OSErr	Delete(void);

	virtual	OSErr	SetFileInfo(CCT_MemFileRec *fileRecP);
	virtual	void	DisposeData(void);
	
	virtual	OSErr	Open(ADFS_IOType ioType, Boolean resForkB);
	virtual	OSErr	Close(void);

	virtual	OSErr	Read(ulong *bytesIO, char *bufP);
	virtual	OSErr	Write(ulong *bytesIO, char *bufP);
	
	virtual	OSErr	VerifyMoveFileWithinVolume(void);
	virtual	OSErr	VerifyFreeSpace(CCT_CopyRec *copyRecP);
	virtual	OSErr	VerifyFileSize(CCopyFile *sourceP, ulong fileSizeL);
	virtual	OSErr	GetSizeSelf(CCT_CopyRec *copyRecP);
	
	virtual	OSErr	ScanForCopySelf(Ptr myDataP, CCopyFile **fileExistsH);

	OSErr			ScanForCopyR(Ptr myDataP, CCopyFile **fileExistsH);
	OSErr			GetSizeR(CCT_CopyRec *copyRecP, CCopyFile *destP);
	
	OSErr			CopySelfTo(Ptr parentFolderP, CCT_CopyRec *copyRecP);
	OSErr			CopyToR(Ptr parentFolderP, CCT_CopyRec *copyRecP);
	
	OSErr			AddEntryR(void);
	
	virtual	OSErr	GetParentRef(Ptr *parentFolderH);
	virtual	OSErr	GetVolumeRef(Ptr *volumeH);
	virtual	OSErr	MoveFileToSelf(CCopyFile *srcFileP);

	virtual	Boolean	IsForked(void);
	virtual	Boolean	SupportsForks(void);
	virtual	OSErr	GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr	SetForkInfo(CCT_ForkInfo *forkInfoP);
	
	/********************************************/
	CCopyTree			*i_copyTreeP;
	
	ADFS_IOType			i_ioType;
	Boolean				i_res_forkB;
	CCT_CopyType		i_copyType;
	Ptr					i_myData;
	
	//	iff I am a folder, then when I call 
	//	"CreateFile" or "CreateFolder", it goes into i_myFileData.
	//	if it's a file, then:
	//	"Open" opens it
	//	"Close" closes it, and calls DisposeData(), and sets it NULL
	//	"Write" writes to it
	//	assert never "Read"
	Ptr					i_myFileData;

	CCopyFile			*i_parentP0;
	CCopyFile			*i_sisterP0;
	CCopyFile			*i_childP0;
};

#endif